let videoControl = new ENABLE.player();
let idx = 0;
let zapName = "";
let _i = ENABLE.input;
let zapTimer;
let saveLastChannelHandler = null;
const SAVE_LAST_CH_TIMEOUT = 180 * 1000;   // 180s
const LS_LAST_CH = "lastChannel";

let dtvCtrl = {
    zapIndex(id) {
        idx = id;
        zapIndex();
    },
    getCurrentChannelIndex() {
        return idx;
    },
    getTextTrack() {
        return videoControl.getTextTrack();
    },
    setTextTrack(id) {
        return videoControl.setTextTrack(id);
    },
    unsetTextTrack() {
        return videoControl.unsetTextTrack();
    },
    getAudioTrack() {
        return videoControl.getAudioTrack();
    },
    setAudioTrack(id) {
        return videoControl.setAudioTrack(id);
    }
};

function showAndroidSettings() {
    ENABLE.application.launchAndroidSystemSettings();
}

function keyHandler(e) {
    var key = e.key;
    var NUM_KEYS = [_i.KEY_0, _i.KEY_1, _i.KEY_2, _i.KEY_3, _i.KEY_4, _i.KEY_5,
    _i.KEY_6, _i.KEY_7, _i.KEY_8, _i.KEY_9, _i.KEY_ENTER];

    // return to skip the following keys comparison
    if (channelListKeyHandler(key, dtvCtrl)) {
        trackListKeyHandler(_i.KEY_BACK);
        hideInfoBar();
        return;
    }
    if (trackListKeyHandler(key, dtvCtrl)) {
        channelListKeyHandler(_i.KEY_BACK);
        hideInfoBar();
        return;
    }
    if (key === _i.KEY_CHANNELUP) {
        idx++;
        zapIndex();
    } else if (key === _i.KEY_CHANNELDOWN) {
        idx--;
        zapIndex();
    } else if (NUM_KEYS.indexOf(key) >= 0) {
        zapNumber(key);
    } else if (key === _i.KEY_INFO) {
        showInfoBar();
    } else if (key === _i.KEY_BLUE) {
        showAndroidSettings();
    }
};

function zapNumber(key) {
    let zapTimeout;
    if (key !== _i.KEY_ENTER && zapName.length < 4) {
        zapName = zapName.concat(key);
        console.info("Digit input: " + zapName);
        showDigitBar(zapName);

        // Wait for next input digit
        zapTimeout = 1000;
    } else if (key === _i.KEY_ENTER && zapName.length > 0) {
        zapTimeout = 100;
    } else {
        return;
    }

    if (zapTimer)
        clearTimeout(zapTimer);
    zapTimer = setTimeout(function () {
        idx = SYSTEM_CONFIG.findDTVChannelIndex(zapName);
        zapIndex();
        zapName = "";
    }, zapTimeout);
}

function zapIndex() {
    let length = SYSTEM_CONFIG.getDTV_Array().length;
    if (idx < 0)
        idx = length - 1;
    if (idx >= length)
        idx = 0;

    let dtv = SYSTEM_CONFIG.getDTV(idx);
    showInfoBar(dtv.name, dtv.desc);
    let src = SYSTEM_CONFIG.getDTV_SourceString(idx);
    let zapData = SYSTEM_CONFIG.getDTV_SourceConfig(idx);

    if (src.indexOf("&rtspsvrtype=") >= 0) {
        src = src.split("&rtspsvrtype=")[0];
    }
    if (src !== "") {
        videoControl.setSource(src, zapData);
        saveLastChannel();
    }
};

function saveLastChannel(saveNow) {
    let ret = ENABLE.system.getINIValue("webapp.save_last_channel");
    if (ret.result !== "true")
        return;

    // cancel previous one
    if (saveLastChannelHandler !== null) {
        clearTimeout(saveLastChannelHandler);
        saveLastChannelHandler = null;
    }

    let dtv = SYSTEM_CONFIG.getDTV(idx);
    if (saveNow) {
        localStorage.setItem(LS_LAST_CH, dtv.name);
    } else {
        saveLastChannelHandler = setTimeout(function () {
            localStorage.setItem(LS_LAST_CH, dtv.name);
        }, SAVE_LAST_CH_TIMEOUT);
    }
}

function getChannelIndex() {
    // 1. try to get channel from URL parameter
    let idx = getChannalNumberFromUrl();
    if (idx >= 0)
        return idx;

    // 2. try to find last channel
    let ret = ENABLE.system.getINIValue("webapp.save_last_channel");
    if (ret.result === "true") {
        // if stored channel number found
        if (localStorage.hasOwnProperty(LS_LAST_CH))
            return SYSTEM_CONFIG.findDTVChannelIndex(localStorage.getItem(LS_LAST_CH));
    }

    // 3. try to find 1st channel from lineup
    idx = SYSTEM_CONFIG.findStartingChannel();
    if (idx >= 0)
        return idx;

    // 4. use 1st channel by default
    return 0;
}

function systemEventHandler(obj) {
    if (obj.event === ENABLE.system.APP_PAUSE) {
        saveLastChannel(true);
    }
}

function getChannalNumberFromUrl() {
    let params = (new URL(document.location)).searchParams;
    let channelNum = parseInt(params.get("channum"));
    if (channelNum >= 0)
        return SYSTEM_CONFIG.findDTVChannelIndex(channelNum);
    let channelName = params.get("channame");
    if (channelName !== "")
        return SYSTEM_CONFIG.findDTVChannelIndexByName(channelName);
    return -1;
}