// Helper for channel configuration
SYSTEM_CONFIG = (function () {
    var default_config = {
        DTV: [], VOD: [], WEB: [], PiP: {}, PVR: {},
        PLTV_BUFFER_SIZE: 0,
        PLTV_DELAY: 0,
        PREFERRED_AUDIO_LANG: "",
        PREFERRED_TEXT_LANG: "",
        STANDBY: {
            powerSaving: {
                enabled: false,
                timeout: 120
            }
        }
    };
    var _local_storage_key = "apollo_zapper_key";
    var _lookupMap = {};
    var _lookupKeysDesc = [];
    var _config = (function () {
        var pref = localStorage.getItem(_local_storage_key);
        if (pref) {
            try {
                _config = JSON.parse(pref);
            } catch (e) {
                console.error("SYSTEM_CONFIG error: " + e);
                _config = {};
            }
            for (cfg in default_config) {
                _config[cfg] = _config[cfg] || default_config[cfg];
            }
            _config.STANDBY.powerSaving = _config.STANDBY.powerSaving || default_config.STANDBY.powerSaving;
            return _config;
        }
        return _config = default_config;
    })();
    return {
        save: function () {
            localStorage.setItem(_local_storage_key, JSON.stringify(_config));
        },
        getVOD_Array: function () {
            return _config.VOD;
        },
        setVOD_Array: function (data) {
            _config.VOD = data;
        },
        getDTV_Array: function () {
            return _config.DTV;
        },
        setDTV_Array: function (data) {
            _config.DTV = data;
            SYSTEM_CONFIG.generateLookupMap();
        },
        getDTV: function (i) {
            if (!_config.DTV.length || i >= _config.DTV.length) {
                return '';
            }
            return _config.DTV[i];
        },
        getDTV_SourceString: function (i) {
            if (!_config.DTV.length || i >= _config.DTV.length) {
                return '';
            }
            var numParams = 0;
            var dtv = _config.DTV[i];
            var s = dtv.type + '://' + dtv.addr;
            if (dtv.type === 'udp' || dtv.type === 'igmp' || dtv.type === 'igmpv3') {
                // multicast channels
                s = 'udp://' + dtv.addr + ':' + dtv.port;

                if (dtv.freq_band !== undefined) {
                    s += "/" + dtv.freq_band;
                }
                if (dtv.type === 'igmpv3') {
                    if (dtv.igmpv3_addr_list.length > 0) {
                        var addr_list = [].concat(dtv.igmpv3_addr_list);
                        s += '?mcast=ssm_' + dtv.igmpv3_mode;
                        while (addr_list.length)
                            s += '&src_addr=' + addr_list.shift();
                    } else {
                        s += '?mcast=asm';
                    }
                }
            } else if (dtv.type === 'dvbt-triplet' || dtv.type === 'dvbt2-triplet') {
                s = "dvb://" + [dtv.dvbt_nid, dtv.dvbt_tsid, dtv.dvbt_sid].join('.');
            } else if (dtv.type === 'mpegdash' || dtv.type === 'nativedash') {
                s = dtv.addr;
            } else if (dtv.type === 'rtsp') {
                s += '&rtspsvrtype=' + dtv.serverType;
            } else if (dtv.type !== 'http' && dtv.type !== 'file' && dtv.type !== 'https') {
                // tuner channels
                s += '/' + dtv.port;

                if (dtv.symbolrate !== undefined) {
                    s += '?symbolRate=' + dtv.symbolrate;
                    numParams++;
                }
                if (dtv.bandwidth !== undefined) {
                    s += (numParams > 0) ? '&' : '?';
                    s += 'bandwidth=' + dtv.bandwidth;
                    numParams++;
                }
                if (dtv.constellation !== undefined) {
                    s += (numParams > 0) ? '&' : '?';
                    s += 'constellation=' + dtv.constellation;
                    numParams++;
                }
                if (dtv.lnb_freq !== undefined) {
                    s += (numParams > 0) ? '&' : '?';
                    s += 'lnb_osc_freq=' + dtv.lnb_freq;
                    numParams++;
                }
                if (dtv.lnb !== undefined) {
                    s += (numParams > 0) ? '&' : '?';
                    s += 'lnb=' + dtv.lnb;
                    numParams++;
                }
                if (dtv.polarity !== undefined) {
                    s += (numParams > 0) ? '&' : '?';
                    s += 'polarity=' + dtv.polarity;
                    numParams++;
                }
                if (dtv.freq_band !== undefined) {
                    s += (numParams > 0) ? '&' : '?';
                    s += 'freq_band=' + dtv.freq_band;
                    numParams++;
                }
            }
            return s;
        },
        getDTV_SourceConfig(i) {
            let zapData = {
                pltdelay: _config.PLTV_DELAY,
                pltbuf: _config.PLTV_BUFFER_SIZE,
                initial_bitrate: _config.HLS_INITIAL_BITRATE
            };
            let dtv = this.getDTV(i);
            // special way to call nativedash
            if (dtv.type === "nativedash") {
                zapData.encryption_type = dtv.encryption_type;
                zapData.encrypting_server = dtv.encrypting_server;
                zapData.encrypting_request_header = dtv.encrypting_request_header;
                zapData.drm_session_type = dtv.drm_session_type;
            }
            return zapData;
        },
        setPltvConfig: function (size, delay) {
            _config.PLTV_BUFFER_SIZE = size;
            _config.PLTV_DELAY = delay;
        },
        setHlsInitialBitrate: function (bitrate) {
            _config.HLS_INITIAL_BITRATE = bitrate;
        },
        findDTVChannelIndex: function (value) {
            // For example, we have channels 100, 110, 120 and 130.
            // [input value -> return value]
            // 135->130, 101->100, 119->110, 60->100

            if (_lookupKeysDesc.length === 0)
                SYSTEM_CONFIG.generateLookupMap();
            if (_lookupKeysDesc.length === 0)
                return -1;

            if (_lookupMap[value])
                return _lookupMap[value]._idx;

            var int_value = parseInt(value);
            for (var i = 0, len = _lookupKeysDesc.length; i < len; ++i) {
                if (int_value > _lookupKeysDesc[i])
                    return _lookupMap[_lookupKeysDesc[i]]._idx;
            }
            return _lookupMap[_lookupKeysDesc[len - 1]]._idx;
        },
        findDTVChannelIndexByName: function (name) {
            // Simply loop the list without indexing
            const result = _config.DTV.find(({ desc }) => desc === name);
            if (result && result._idx >= 0)
                return result._idx;
            return -1;
        },
        generateLookupMap: function () {
            var arr = _config.DTV;
            _lookupMap = {};
            for (var i = 0, len = arr.length; i < len; ++i) {
                _lookupMap[arr[i].name] = arr[i];
                arr[i]._idx = i;
            }
            _lookupKeysDesc = Object.keys(_lookupMap).sort(function (a, b) { return b - a });
        },
        findStartingChannel() {
            let arr = _config.DTV;
            let idx = arr.findIndex(function (ch) {
                if (ch.starting == true) // use == , in case someone really set a string
                    return true;
            });
            return idx;
        }
    };
})();
