let saveToConfig = function (data) {
    if (data instanceof Array) {
        // for backward compatible
        SYSTEM_CONFIG.setDTV_Array(data);
    } else {
        // allow the lineup.json also contain info of VOD
        if (data.DTV)
            SYSTEM_CONFIG.setDTV_Array(data.DTV);
        if (data.VOD)
            SYSTEM_CONFIG.setVOD_Array(data.VOD);
    }
    SYSTEM_CONFIG.save();
}

const lineup = {
    import() {
        const applyJSON = function (json_str, resolve) {
            try {
                let obj = JSON.parse(json_str);
                saveToConfig(obj);
            } catch (error) {
                console.error("Invalid json format", json_str);
            }
            resolve();
        };

        const readLineup = function (resolve) {
            // USB lineup with higher priority
            let ret = ENTONE.file.getUSBLineupIfExist();
            if (ret.result !== "") {
                applyJSON(ret.result, resolve);
            } else {
                ret = ENTONE.file.getINILineupIfExist();
                if (ret.result !== "") {
                    applyJSON(ret.result, resolve);
                } else {
                    resolve();
                }
            }
        }
        return new Promise(readLineup);
    }
}
