/*
 * Copyright 2014-2024 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license.
 */

navigationPageText = Promise.resolve(`<div class="toc--part" id="AminoSandboxedPlayer-nav-submenu" pageId="AminoSandboxedPlayer::////PointingToDeclaration//1946847589" data-nesting-level="0">
  <div class="toc--row"><button class="toc--button" onclick="document.getElementById(&quot;AminoSandboxedPlayer-nav-submenu&quot;).classList.toggle(&quot;toc--part_hidden&quot;);"></button><a href="index.html" class="toc--link"><span>Amino</span><wbr></wbr><span>Sandboxed</span><wbr></wbr><span><span>Player</span></span></a></div>
  <div class="toc--part" id="AminoSandboxedPlayer-nav-submenu-0" pageId="AminoSandboxedPlayer::com.aminocom.libplayer////PointingToDeclaration//1946847589" data-nesting-level="1">
    <div class="toc--row"><button class="toc--button" onclick="document.getElementById(&quot;AminoSandboxedPlayer-nav-submenu-0&quot;).classList.toggle(&quot;toc--part_hidden&quot;);"></button><a href="-amino-sandboxed-player/com.aminocom.libplayer/index.html" class="toc--link"><span>com.</span><wbr></wbr><span>aminocom.</span><wbr></wbr><span>libplayer</span></a></div>
    <div class="toc--part" id="AminoSandboxedPlayer-nav-submenu-0-0" pageId="AminoSandboxedPlayer::com.aminocom.libplayer/PlaybackInfo///PointingToDeclaration//1946847589" data-nesting-level="2">
      <div class="toc--row"><a href="-amino-sandboxed-player/com.aminocom.libplayer/-playback-info/index.html" class="toc--link"><span class="toc--link-grid"><span class="toc--icon class"></span><span><span>Playback</span><wbr></wbr><span><span>Info</span></span></span></span></a></div>
    </div>
    <div class="toc--part" id="AminoSandboxedPlayer-nav-submenu-0-1" pageId="AminoSandboxedPlayer::com.aminocom.libplayer/PlayerEvent///PointingToDeclaration//1946847589" data-nesting-level="2">
      <div class="toc--row"><a href="-amino-sandboxed-player/com.aminocom.libplayer/-player-event/index.html" class="toc--link"><span class="toc--link-grid"><span class="toc--icon class"></span><span><span>Player</span><wbr></wbr><span><span>Event</span></span></span></span></a></div>
    </div>
    <div class="toc--part" id="AminoSandboxedPlayer-nav-submenu-0-2" pageId="AminoSandboxedPlayer::com.aminocom.libplayer/PlayerEventListener///PointingToDeclaration//1946847589" data-nesting-level="2">
      <div class="toc--row"><a href="-amino-sandboxed-player/com.aminocom.libplayer/-player-event-listener/index.html" class="toc--link"><span class="toc--link-grid"><span class="toc--icon interface"></span><span><span>Player</span><wbr></wbr><span>Event</span><wbr></wbr><span><span>Listener</span></span></span></span></a></div>
    </div>
    <div class="toc--part" id="AminoSandboxedPlayer-nav-submenu-0-3" pageId="AminoSandboxedPlayer::com.aminocom.libplayer/SandboxedPlayer///PointingToDeclaration//1946847589" data-nesting-level="2">
      <div class="toc--row"><a href="-amino-sandboxed-player/com.aminocom.libplayer/-sandboxed-player/index.html" class="toc--link"><span class="toc--link-grid"><span class="toc--icon class"></span><span><span>Sandboxed</span><wbr></wbr><span><span>Player</span></span></span></span></a></div>
    </div>
    <div class="toc--part" id="AminoSandboxedPlayer-nav-submenu-0-4" pageId="AminoSandboxedPlayer::com.aminocom.libplayer/SystemUtil///PointingToDeclaration//1946847589" data-nesting-level="2">
      <div class="toc--row"><a href="-amino-sandboxed-player/com.aminocom.libplayer/-system-util/index.html" class="toc--link"><span class="toc--link-grid"><span class="toc--icon class"></span><span><span>System</span><wbr></wbr><span><span>Util</span></span></span></span></a></div>
    </div>
    <div class="toc--part" id="AminoSandboxedPlayer-nav-submenu-0-5" pageId="AminoSandboxedPlayer::com.aminocom.libplayer/TrackInfo///PointingToDeclaration//1946847589" data-nesting-level="2">
      <div class="toc--row"><a href="-amino-sandboxed-player/com.aminocom.libplayer/-track-info/index.html" class="toc--link"><span class="toc--link-grid"><span class="toc--icon class"></span><span><span>Track</span><wbr></wbr><span><span>Info</span></span></span></span></a></div>
    </div>
  </div>
</div>
`)

displayNavigationFromPage = () => {
    navigationPageText.then(data => {
        document.getElementById("sideMenu").innerHTML = data;
    }).then(() => {
        document.querySelectorAll(".toc--row > a").forEach(link => {
            link.setAttribute("href", pathToRoot + link.getAttribute("href"));
        })
    }).then(() => {
        document.querySelectorAll(".toc--part").forEach(nav => {
            if (!nav.classList.contains("toc--part_hidden"))
                nav.classList.add("toc--part_hidden")
        })
    }).then(() => {
        revealNavigationForCurrentPage()
    }).then(() => {
        scrollNavigationToSelectedElement()
    })
    document.querySelectorAll('.footer a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            document.querySelector(this.getAttribute('href')).scrollIntoView({
                behavior: 'smooth'
            });
        });
    });
}

revealNavigationForCurrentPage = () => {
    let pageId = document.getElementById("content").attributes["pageIds"].value.toString();
    let parts = document.querySelectorAll(".toc--part");
    let found = 0;
    do {
        parts.forEach(part => {
            if (part.attributes['pageId'].value.indexOf(pageId) !== -1 && found === 0) {
                found = 1;
                if (part.classList.contains("toc--part_hidden")) {
                    part.classList.remove("toc--part_hidden");
                    part.setAttribute('data-active', "");
                }
                revealParents(part)
            }
        });
        pageId = pageId.substring(0, pageId.lastIndexOf("/"))
    } while (pageId.indexOf("/") !== -1 && found === 0)
};
revealParents = (part) => {
    if (part.classList.contains("toc--part")) {
        if (part.classList.contains("toc--part_hidden"))
            part.classList.remove("toc--part_hidden");
        revealParents(part.parentNode)
    }
};

scrollNavigationToSelectedElement = () => {
    let selectedElement = document.querySelector('div.toc--part[data-active]')
    if (selectedElement == null) { // nothing selected, probably just the main page opened
        return
    }

    let hasIcon = selectedElement.querySelectorAll(":scope > div.toc--row span.toc--icon").length > 0

    // for an instance enums also have children and are expandable but are not package/module elements
    let isPackageElement = selectedElement.children.length > 1 && !hasIcon
    if (isPackageElement) {
        // if a package is selected or linked, it makes sense to align it to top
        // so that you can see all the members it contains
        selectedElement.scrollIntoView(true)
    } else {
        // if a member within a package is linked, it makes sense to center it since it,
        // this should make it easier to look at surrounding members
        selectedElement.scrollIntoView({
            behavior: 'auto',
            block: 'center',
            inline: 'center'
        })
    }
}

/*
    This is a work-around for safari being IE of our times.
    It doesn't fire a DOMContentLoaded, presumably because eventListener is added after it wants to do it
*/
if (document.readyState === 'loading') {
    window.addEventListener('DOMContentLoaded', () => {
        displayNavigationFromPage()
    })
} else {
    displayNavigationFromPage()
}
